import service from '@/utils/request'

export const useAuthorityListApi = () => {
	return service.get('/sys/menu/authority')
}

export const useMenuListApi = (type: Number, applicationCode: String) => {
	// 菜单类型 0：菜单  1：按钮  2：接口
	const menuType = type === 2 ? 2 : 0

	return service.get('/sys/menu/list?type=' + menuType + '&applicationCode=' + applicationCode)
}

export const createItemApi = (dataForm: any) => {
	return service.post('/fast/report/createItem', dataForm)
}

export const useReportApi = (id: Number) => {
	return service.get('/fast/report/' + id)
}

export const getReportConfig = (data: any) => {
	return service.post('/fast/report/getReportConfig', data)
}

export const getReportIdByReportCode = (data: any) => {
	return service.post('/fast/report/getReportIdByReportCode', data)
}


export const useReportSubmitApi = (dataForm: any) => {
	if (dataForm.id) {
		return service.put('/fast/report', dataForm)
	} else {
		return service.post('/fast/report', dataForm)
	}
}

export const baseUploadApi = (dataForm: any) => {
	return service.post('/fast/report/reportImport', dataForm)
}
