import { createApp } from 'vue'
import ElementPlus from 'element-plus'
import App from './App.vue'
import { createPinia } from 'pinia'
import { directive } from './utils/directive'
import { router } from './router'
import { i18n } from './i18n'
import 'virtual:svg-icons-register'

import '@/icons/iconfont/iconfont'
import 'element-plus/dist/index.css'
import '@/styles/index.scss'
import VForm3 from '@/../lib/vform/designer.umd.js'
import '../lib/vform/designer.style.css'

import 'xe-utils'
import VXETable from 'vxe-table'
import 'vxe-table/lib/style.css'

import FastTableColumn from '@/components/fast-table-column'
import FastRadioGroup from '@/components/fast-radio-group'
import FastSelect from '@/components/fast-select'
import FastUser from '@/components/fast-user'
import FastTransferUser from '@/components/fast-transfer-user'
import FastTransferRole from '@/components/fast-transfer-role'
import FastTransferPost from '@/components/fast-transfer-post'
import SvgIcon from '@/components/svg-icon'

VXETable.setup({
	zIndex: 3000,
	select: {
		transfer: true
	}
})

const app = createApp(App)
app.use(createPinia())

// 注册 自定义指令
directive(app)
app.use(router)
app.use(i18n)
app.use(FastTableColumn)
app.use(FastRadioGroup)
app.use(FastSelect)
app.use(FastUser)
app.use(FastTransferUser)
app.use(FastTransferRole)
app.use(FastTransferPost)
app.use(SvgIcon)
app.use(ElementPlus)
app.use(VXETable)
app.use(VForm3)
// 注册自定义指令 v-prevent-reclick

app.directive('prevent-reclick', {
	beforeMount(el, binding) {
		el.disabled = false // 初始化时启用按钮
		el.addEventListener('click', () => {
			el.disabled = true // 点击后禁用按钮
			setTimeout(() => {
				el.disabled = false // 在指定的时间后重新启用按钮
			}, binding.value || 3000) // 使用 binding.value 来设置等待时间，默认为 1000 毫秒
		})
	},
	unmounted(el) {
		// 组件卸载时移除事件监听器
		//el.removeEventListener('click')
	}
})
app.mount('#app')
