import { reactive,toRefs } from 'vue'
import { QueryFomType,RoleDataType } from '../types/fastTransferRole'
import { useCrud } from '@/hooks'
import { IHooksOptions } from '@/hooks/interface'
interface FastTransferUser extends IHooksOptions {
    queryForm: QueryFomType;
    dataList: RoleDataType[]
}
export default () => {
    const state: FastTransferUser = reactive({
        createdIsNeed: false,
        dataListUrl: '/sys/role/page',
        queryForm: {},
        dataList: []
    })
    const { getDataList,selectionChangeHandle,sizeChangeHandle,currentChangeHandle } = useCrud(state);
    const { queryForm,dataList,dataListLoading,page,pageSizes,limit,total,dataListTableSelection } = toRefs(state);
    const resetData = () => {
        queryForm.value = {};
        dataListTableSelection!.value = [];
        page!.value = 1;
    }
    return {
        getDataList,
        selectionChangeHandle,
        sizeChangeHandle,
        currentChangeHandle,
        queryForm,
        dataList,
        dataListLoading,
        page,
        pageSizes,
        limit,
        total,
        dataListTableSelection,
        resetData
    }
}