import { reactive,toRefs } from 'vue'
import { QueryFomType,PostDataType } from '../types/fastTransferPost'
import { useCrud } from '@/hooks'
import { IHooksOptions } from '@/hooks/interface'
interface FastTransferPost extends IHooksOptions {
    queryForm: QueryFomType;
    dataList: PostDataType[]
}
export default () => {
    const state: FastTransferPost = reactive({
        createdIsNeed: false,
        dataListUrl: '/sys/post/page',
        queryForm: {
            status: 1
        },
        dataList: []
    })
    const { getDataList,selectionChangeHandle,sizeChangeHandle,currentChangeHandle } = useCrud(state);
    const { queryForm,dataList,dataListLoading,page,pageSizes,limit,total,dataListTableSelection } = toRefs(state);
    const resetData = () => {
        queryForm.value = {
            status: 1
        };
        dataListTableSelection!.value = [];
        page!.value = 1;
    }
    return {
        getDataList,
        selectionChangeHandle,
        sizeChangeHandle,
        currentChangeHandle,
        queryForm,
        dataList,
        dataListLoading,
        page,
        pageSizes,
        limit,
        total,
        dataListTableSelection,
        resetData
    }
}