import service from '@/utils/request'

export const useUserInfoApi = () => {
	return service.get('/sys/tenant/info')
}

export const updatePasswordApi = (data: any) => {
	return service.put('/sys/tenant/password', data)
}

export const useTenantApi = (id: number) => {
	return service.get('/sys/tenant/' + id)
}

export const useTenantSubmitApi = (dataForm: any) => {
	if (dataForm.id) {
		return service.put('/sys/tenant', dataForm)
	} else {
		return service.post('/sys/tenant', dataForm)
	}
}
