import { reactive,toRefs } from 'vue'
import { QueryFomType,UserDataType } from '../types/fastTransferUser'
import { useCrud } from '@/hooks'
import { IHooksOptions } from '@/hooks/interface'
interface FastTransferUser extends IHooksOptions {
    queryForm: QueryFomType;
    dataList: UserDataType[]
}
export default () => {
    const state: FastTransferUser = reactive({
        createdIsNeed: false,
        dataListUrl: '/sys/user/page',
        queryForm: {
            gender: ''
        },
        dataList: [],
    })
    const { getDataList,selectionChangeHandle,sizeChangeHandle,currentChangeHandle } = useCrud(state);
    const { queryForm,dataList,dataListLoading,page,pageSizes,limit,total,dataListTableSelection } = toRefs(state);
    const resetData = () => {
        queryForm.value = {
            gender: ''
        };
        dataListTableSelection!.value = [];
        page!.value = 1;
    }
    return {
        getDataList,
        selectionChangeHandle,
        sizeChangeHandle,
        currentChangeHandle,
        queryForm,
        dataList,
        dataListLoading,
        page,
        pageSizes,
        limit,
        total,
        dataListTableSelection,
        resetData
    }
}