import service from '@/utils/request'


/**
 * 获取几点信息
 * @param flowId
 * @returns {AxiosPromise}
 */
export const getHistoryActivityList = (flowId:any) => {
  return service.post('/flow2/getHistoryActivityListAndNodes',{ flowId: flowId })
}

/**
 * 提交审批
 * @param flowId
 * @param opinion
 * @param comment
 * @returns {AxiosPromise}
 */
export const complete = (flowId :any, opinion:any, comment:any) => {
  return service.post('/flow/process/complete',{ flowId: flowId, opinion: opinion, comment: comment })
}

export const getCurrentNodeInfo = (flowId: any) => {
  return service.post('/flow2/getCurrentNodeInfo', { flowId: flowId })
}

/**
 * 转办
 * @param flowId
 * @param username
 */
export const transition = (flowId:any, username:any) => {
  return service.post('/flow/transition', { flowId: flowId, username: username })
}
export const stop = (flowId:any, reason:any) => {
  return service.post( '/flow/stop',{ flowId: flowId, reason: reason })
}

