package com.ebo.module.task;

import com.ebo.module.utils.SendMessageEmail;
import com.ebo.monitor.model.Cpu;
import com.xxl.job.core.handler.IJobHandler;
import com.xxl.job.core.handler.annotation.XxlJob;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;


@Component
@Slf4j
public class CpuMonitorHandler extends IJobHandler {
    @Autowired
    private SendMessageEmail sendMessageEmail;

    @XxlJob("cpuMonitorJob")
    @Override
    public void execute() throws Exception {
        log.info("Cpu Monitor Job Start");


        Cpu cpu = new Cpu();
        double free = cpu.getFree();
        double threshold = 90;
        if((100-free) > threshold){
            try{
                sendMessageEmail.sendAlert("Cpu内存占用过高警告", "目前内存占用为: " + (100-free) + "%");
            }catch (Exception e){
                e.printStackTrace();
            }
        }else {
            log.info("Cpu内存占用正常: " + (100-free) + "%");
        }
        log.info("Cpu Monitor Job End");
    }

}