package com.ebo.module.task;

import com.ebo.module.utils.SendMessageEmail;
import com.ebo.monitor.model.Jvm;
import com.xxl.job.core.handler.IJobHandler;
import com.xxl.job.core.handler.annotation.XxlJob;
import lombok.extern.slf4j.Slf4j;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;


@Component
@Slf4j
public class JvmMonitorHandler extends IJobHandler {
    @Autowired
    private SendMessageEmail sendMessageEmail;
    @XxlJob("jvmMonitorJob")
    @Override
    public void execute() throws Exception {
        log.info("Jvm Monitor Job Start");
        Jvm jvm = new Jvm();
        double jvmUsage = jvm.getUsage();
        double threshold = 90;
        if (jvmUsage > threshold){
            try{
                sendMessageEmail.sendAlert("Jvm内存占用过高","目前Jvm内存占用为："+jvmUsage+"%，请及时检测内存是否泄露");
            }catch (RuntimeException e){
                e.printStackTrace();
            }
        }else {
            log.info("内存占用正常: " + jvmUsage + "%");
        }
        log.info("Jvm Monitor Job End");
    }

}