package com.ebo.workOrder.serviceBtnEnhance;

import com.alibaba.fastjson.JSON;
import com.ebo.entity.WorkOrderEntity;
import com.ebo.framework.common.exception.ServerException;
import com.ebo.mapper.WorkOrderMapper;
import com.ebo.mapper.WorkOrderServiceMapper;
import com.ebo.module.fast.common.BtnServerEnhanceJavaInter;
import jakarta.annotation.Resource;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.io.Serializable;
import java.net.MalformedURLException;
import java.util.Map;

@Service
@Slf4j
public class CloseWorkOrderServiceBtnEnhance implements BtnServerEnhanceJavaInter {
    @Resource
    private WorkOrderMapper workOrderMapper;
    @Resource
    private WorkOrderServiceMapper workOrderServiceMapper;

    @Override
    public void executeBefore(String tableName, String buttonCode, Map data) throws ServerException {

    }

    /**
     * 业务增强往service插入数据
     * @param tableName
     * @param buttonCode
     * @param data
     * @throws ServerException
     * @throws MalformedURLException
     */
    @Override
    public void executeAfter(String tableName, String buttonCode, Map data) throws ServerException, MalformedURLException {
        log.info("-----关单业务增强-----{}", JSON.toJSON(data));
        WorkOrderEntity workOrderEntity = workOrderMapper.selectById((Serializable) data.get("id"));
        String closeType = workOrderEntity.getCloseOrderType();
        //等于服务工单
        if(workOrderEntity.getWorkOrderType().equals("1")){
            /**
             * 底层没改完动不了
             * @TODO
             */
//            if(workOrderEntity.getCloseOrderType().equals("1")){
//                workOrderServiceMapper.selectById(workOrderEntity.getWorkOrderNumber());
//
//            }
        }else {
            throw new RuntimeException("不是服务工单");
        }

    }
}
