package com.ebo.workOrder.BtnEnhance;

import com.ebo.entity.WorkOrderEntity;
import com.ebo.framework.common.exception.ServerException;
import com.ebo.mapper.WorkOrderMapper;
import com.ebo.module.fast.common.BtnServerEnhanceJavaInter;
import jakarta.annotation.Resource;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.io.Serializable;
import java.net.MalformedURLException;
import java.util.Map;

@Service
@Slf4j
public class DeleteWorkOrder implements BtnServerEnhanceJavaInter {
    @Resource
    private WorkOrderMapper workOrderMapper;
    @Override
    public void executeBefore(String tableName, String buttonCode, Map data) throws ServerException {

    }

    @Override
    public void executeAfter(String tableName, String buttonCode, Map data) throws ServerException, MalformedURLException {
        log.info("-----业务增强，删除草稿箱工单------");
        WorkOrderEntity workOrderEntity = workOrderMapper.selectById((Serializable) data.get("id"));
        if(workOrderEntity.getStatus().equals("7")){
            workOrderEntity.setDeleteFlag(1);
            workOrderMapper.updateById(workOrderEntity);
        }else{
            throw new RuntimeException("工单不在草稿箱无法删除");
        }

    }
}
