package com.ebo.workOrder.BtnEnhance;

import cn.hutool.core.date.DateTime;
import com.ebo.entity.WorkOrderEntity;
import com.ebo.framework.common.exception.ServerException;
import com.ebo.mapper.WorkOrderMapper;
import com.ebo.module.fast.common.BtnServerEnhanceJavaInter;
import jakarta.annotation.Resource;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.net.MalformedURLException;
import java.util.Map;

@Service
@Slf4j
public class CancelSuspendBtnEnhance implements BtnServerEnhanceJavaInter {
    @Resource
    private WorkOrderMapper workOrderMapper;
    @Override
    public void executeBefore(String tableName, String buttonCode, Map data) throws ServerException {

    }

    @Override
    public void executeAfter(String tableName, String buttonCode, Map data) throws ServerException, MalformedURLException {
        log.info("-----工单挂起业务增强，记录次数和时间-----");
        String idValue = (String) data.get("id");
        WorkOrderEntity workOrderEntity = workOrderMapper.selectById(idValue);
        if(workOrderEntity.getStatus().equals("6")){
            workOrderEntity.setStatus("3");
        }else {
            throw new RuntimeException("出现异常，订单已取消挂起");
        }
        workOrderEntity.setSuspensionTime(DateTime.now());
        workOrderMapper.updateById(workOrderEntity);
    }
}
