package com.ebo.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.util.Date;

import com.ebo.framework.mybatis.entity.BaseEntity;
import lombok.Data;

/**
 * 
 * @TableName work_order
 */
@TableName(value ="work_order")
@Data
public class WorkOrderEntity extends BaseEntity implements Serializable {
    /**
     * 
     */
    @TableId
    private String id;

    /**
     * 租户ID，用于多租户区分
     */
    private String tenantCode;

    /**
     * 
     */
    private Integer version;

    /**
     * 
     */
    private Integer deleteFlag;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 更新时间
     */
    private Date updateTime;

    /**
     * 创建人姓名
     */
    private String creatorName;

    /**
     * 创建人ID
     */
    private String creator;

    /**
     * 更新人姓名
     */
    private String updaterName;

    /**
     * 更新人ID
     */
    private String updater;

    /**
     * 工单编号，唯一标识每个工单
     */
    private String workOrderNumber;

    /**
     * 工单状态，1-待派单；2-待接单，3-处理中，4-已完成，关单
     */
    private String status;

    /**
     * 自动派单状态，例如：0-未派单，1-已派单
     */
    private Integer autoDispatchStatus;

    /**
     * 工单标题，简要描述问题
     */
    private String title;

    /**
     * 工单描述，详细说明工单内容
     */
    private String description;

    /**
     * 工单附件，存储附件链接或文件信息
     */
    private String attachment;

    /**
     * 优先级，例如：1-低，2-中，3-高
     */
    private String priority;

    /**
     * 是否延迟，例如：0-否，1-是
     */
    private Integer isDelay;

    /**
     * 工单关注者id
     */
    private String externalId;

    /**
     * 
     */
    private String externalName;

    /**
     * 任务池ID，标识工单所在的任务池
     */
    private String taskPoolId;

    /**
     * 任务组ID，标识工单所属的任务组
     */
    private String taskGroupId;

    /**
     * 任务组名称
     */
    private String taskGroupName;

    /**
     * 账号ID，关联用户信息
     */
    private String userId;

    /**
     * 创建者部门ID
     */
    private String creatorDepartmentId;

    /**
     * 创建者部门名称
     */
    private String creatorDepartmentName;

    /**
     * 工单类型，例如：1-服务工单、2-需求工单
     */
    private String workOrderType;

    /**
     * 父工单类型
     */
    private String parentWorkOrderType;

    /**
     * 父工单编号
     */
    private String parentWorkOrderNumber;

    /**
     * 根工单类型
     */
    private String  rootWorkOrderType;

    /**
     * 根工单编号
     */
    private String rootWorkOrderNumber;

    /**
     * 是否自动派单，例如：0-否，1-是
     */
    private String isAutoDispatch;

    /**
     * 提交人ID
     */
    private String submitterId;

    /**
     * 提交人姓名
     */
    private String submitterName;

    /**
     * 提交人部门ID
     */
    private String submitterDepartmentId;

    /**
     * 提交人部门名称
     */
    private String submitterDepartmentName;

    /**
     * 派单人ID
     */
    private String dispatcherId;

    /**
     * 派单人姓名
     */
    private String dispatcherName;

    /**
     * 派单人部门ID
     */
    private String dispatcherDepartmentId;

    /**
     * 派单人部门名称
     */
    private String dispatcherDepartmentName;

    /**
     * 处理人ID
     */
    private String handlerId;

    /**
     * 处理人姓名
     */
    private String handlerName;

    /**
     * 处理人部门ID
     */
    private String handlerDepartmentId;

    /**
     * 处理人部门名称
     */
    private String handlerDepartmentName;

    /**
     * 催办次数
     */
    private Integer followUpCount;

    /**
     * 催办时间
     */
    private Date followUpTime;

    /**
     * 驳回次数
     */
    private Integer rejectionCount;

    /**
     * 预计关单时间
     */
    private Date estimatedCloseTime;

    /**
     * 预计需要工时，单位：小时
     */
    private Integer estimatedWorkHours;

    /**
     * 接单时间
     */
    private Date acceptTime;

    /**
     * 关单类型，例如：1-手动关单，2-自动关单
     */
    private String closeOrderType;

    /**
     * 提交关单时间
     */
    private Date closeOrderSubmissionTime;

    /**
     * 提交关单描述
     */
    private String closeOrderDescription;

    /**
     * 关单附件
     */
    private String closeOrderAttachment;

    /**
     * 真实关单时间
     */
    private Date actualCloseTime;

    /**
     * 真实工时，单位：小时
     */
    private Integer actualWorkHours;

    /**
     * 驳回关闭时间
     */
    private Date rejectionCloseTime;

    /**
     * 驳回原因
     */
    private String rejectionReason;

    /**
     * 挂起时间
     */
    private Date suspensionTime;

    /**
     * 取消挂起时间
     */
    private Date cancelSuspensionTime;

    /**
     * 挂起次数
     */
    private Integer suspensionCount;

    /**
     * 撤回时间
     */
    private Date withdrawalTime;

    /**
     * 撤回原因
     */
    private String withdrawalReason;

    /**
     * 验收撤回时间
     */
    private Date acceptanceWithdrawalTime;

    /**
     * 验收撤回原因
     */
    private String acceptanceWithdrawalReason;

    /**
     * 提单时间
     */
    private Date submitterTime;

    /**
     * 派单时间
     */
    private Date dispatchTime;

    /**
     * 挂起原因
     */
    private String suspensionReason;

    /**
     * 旧的工单编号
     */
    private String oldWorkOrder;

    /**
     * 流程编号
     */
    private String oaFlowNo;

    /**
     * 旧的附件
     */
    private String oldAttachment;

    /**
     * 旧的关单附件
     */
    private String oldCloseAttachment;

    /**
     * 流程状态：1-审批中，2-退回，3-通过，4-终止
     */
    private Integer oaFlowStatus;

//    @TableField(exist = false)
//    private static final long serialVersionUID = 1L;
}