package com.ebo.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.util.Date;

import com.ebo.framework.mybatis.entity.BaseEntity;
import lombok.Data;

/**
 * 用于存储调度规则的表
 * @TableName dispatch_rule
 */
@TableName(value ="dispatch_rule")
@Data
public class DispatchRuleEntity extends BaseEntity implements Serializable {
    /**
     * 主键，唯一标识调度规则
     */
    @TableId
    private String id;

    /**
     * 删除标识，0表示未删除，1表示已删除
     */
    private Integer deleteFlag;

    /**
     * 数据版本，用于乐观锁控制
     */
    private Integer version;

    /**
     * 租户标识，用于区分不同租户的数据
     */
    private String tenantCode;

    /**
     * 记录创建时间
     */
    private Date createTime;

    /**
     * 记录最近一次更新时间
     */
    private Date updateTime;

    /**
     * 创建人姓名
     */
    private String creatorName;

    /**
     * 创建人账号
     */
    private String creator;

    /**
     * 更新人姓名
     */
    private String updaterName;

    /**
     * 更新人账号
     */
    private String updater;

    /**
     * 优先级，用于规则执行的排序
     */
    private Integer priority;

    /**
     * 状态，表示规则的当前状态（例如，启用或禁用）
     */
    private String  status;

    /**
     * 规则名称，描述规则的功能或用途
     */
    private String name;

    /**
     * 规则类别，用于分类不同的规则,1启用，2禁用
     */
    private String category;

    @TableField(exist = false)
    private static final long serialVersionUID = 1L;
}