package com.ebo.module.task;

import com.ebo.module.utils.GetAccessToken;
import com.ebo.module.utils.SendMessageEmail;
import com.google.gson.Gson;
import com.xxl.job.core.handler.IJobHandler;
import com.xxl.job.core.handler.annotation.XxlJob;
import lombok.extern.slf4j.Slf4j;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.io.IOException;
import java.util.Map;

@Component
@Slf4j
public class JvmMonitorHandler extends IJobHandler {
    @Autowired
    private SendMessageEmail sendMessageEmail;
    private final static String apiUrl = "http://localhost:8659/monitor/server/jvm";

    @XxlJob("jvmMonitorJob")
    @Override
    public void execute() throws Exception {
        log.info("Jvm Monitor Job Start");
        String accessToken = GetAccessToken.getAccessToken();
        if (accessToken == null) {
            log.error("获取令牌失败");
            return;
        }
        // 构建带有查询参数的 URL
        URIBuilder uriBuilder = new URIBuilder(apiUrl);
        uriBuilder.addParameter("access_token", accessToken);
        String urlWithParams = uriBuilder.build().toString();

        CloseableHttpClient httpClient = HttpClients.createDefault();
        HttpGet httpGet = new HttpGet(urlWithParams);

        CloseableHttpResponse response = null;
        try {
            response = httpClient.execute(httpGet);
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                String result = EntityUtils.toString(entity);
                // 解析响应数据
                Map<String, Object> responseresult = new Gson().fromJson(result, Map.class);
                Map<String, Object> data = (Map<String, Object>) responseresult.get("data");
                log.info("data为{}",data);
                double max = Double.parseDouble(data.get("max").toString());
                double total = Double.parseDouble(data.get("total").toString());
                double jvmUsage = total/max;
                double threshold = 90; // 设置阈值
                if (jvmUsage > threshold) {
                    // 发送警报
                    sendMessageEmail.sendAlert("内存占用过高警告", "目前内存占用为: " + jvmUsage + "%");
                } else {
                    log.info("内存占用正常: " + jvmUsage + "%");
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            try {
                if (response != null) {
                    response.close();
                }
                httpClient.close();
            } catch (IOException e) {
                e.printStackTrace();
            }
        }

        log.info("Jvm Monitor Job End");
    }

}