package com.ebo.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.util.Date;

import com.ebo.framework.mybatis.entity.BaseEntity;
import lombok.Data;

/**
 * 继承BaseEntity完成公共字段填充
 * 服务单表，用于记录和管理服务单相关的信息，包括问题分类、故障描述、关闭类型等
 * @TableName work_order_service
 */
@TableName(value ="work_order_service")
@Data
public class WorkOrderServiceEntity extends BaseEntity implements Serializable {
    /**
     * 是否转为需求标识，0 表示否，1 表示是
     */
    private Integer isTransformDemand;

    /**
     * 问题所属系统标识，例如具体模块或子系统
     */
    private Integer system1;

    /**
     * 二级问题分类标识，例如细化的分类
     */
    private Integer secondLevelId;

    /**
     * 三级问题分类标识，用于更具体的问题分类
     */
    private Integer thirdLevelId;

    /**
     * 故障现象标识，例如具体的异常类型
     */
    private Integer faultSymptoms;

    /**
     * 问题归因标识，用于描述问题的来源或责任方
     */
    private Integer problemAttribution;

    /**
     * 服务单关闭类型，例如正常关闭、异常关闭等
     */
    private Integer serviceCloseType;

    /**
     * 问题所属系统的名称，便于识别和显示
     */
    private String systemName;

    /**
     * 二级问题分类的名称，便于描述和显示
     */
    private String secondLevelName;

    /**
     * 三级问题分类的名称，更具体地描述问题分类
     */
    private String thirdLevelName;

    /**
     * 故障现象名称，例如描述具体的异常类型
     */
    private String faultSymptomsName;

    /**
     * 问题归因名称，例如责任方或来源描述
     */
    private String problemAttributionName;

    /**
     * 服务单关闭类型的名称，例如“正常关闭”或“异常关闭”
     */
    private String serviceCloseTypeName;

    @TableField(exist = false)
    private static final long serialVersionUID = 1L;
}