package com.ebo.module.task;

import com.ebo.module.utils.SendMessageEmail;
import com.ebo.monitor.model.Sys;
import com.xxl.job.core.handler.IJobHandler;
import com.xxl.job.core.handler.annotation.XxlJob;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
@Component
@Slf4j
public class SysMonitorHandler extends IJobHandler {
    @Autowired
    private SendMessageEmail sendMessageEmail;
    @XxlJob("sysMonitorJob")
    @Override
    public void execute() throws Exception {
        log.info("Memory Monitor Job Start");
        try {
            Sys sys = new Sys();
            sendMessageEmail.sendAlert("操作系统信息查看", "目前操作系统为 " + sys);
        }catch (RuntimeException e){
            e.printStackTrace();
        }
    }
}
