package com.ebo.workOrder.serviceBtnEnhance;

import com.alibaba.fastjson.JSON;
import com.ebo.entity.WorkOrderEntity;
import com.ebo.framework.common.exception.ServerException;
import com.ebo.mapper.WorkOrderMapper;
import com.ebo.module.fast.common.BtnServerEnhanceJavaInter;
import jakarta.annotation.Resource;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.net.MalformedURLException;
import java.util.Map;

@Slf4j
@Service
public class FollowUpCountBtnEnhance implements BtnServerEnhanceJavaInter {
    @Resource
    private WorkOrderMapper workOrderMapper;

    @Override
    public void executeBefore(String tableName, String buttonCode, Map data) throws ServerException {
        log.info("-----调用催办业务增强方法,增加催办次数，更新催办时间{}-----", JSON.toJSONString(data));
        String  idValue = (String) data.get("id");
        WorkOrderEntity workOrderEntity = workOrderMapper.selectById(idValue);
        if(workOrderEntity.getFollowUpCount() == null){
            workOrderEntity.setFollowUpCount(0);
        }else {
            workOrderEntity.setFollowUpCount(workOrderEntity.getFollowUpCount()+1);
        }
        log.info("值为{}",workOrderEntity.getWorkOrderNumber());
        if(workOrderEntity.getParentWorkOrderNumber() == null || workOrderEntity.getParentWorkOrderNumber().isEmpty()){
            workOrderEntity.setRootWorkOrderNumber(workOrderEntity.getWorkOrderNumber());
            workOrderEntity.setWorkOrderType(workOrderEntity.getWorkOrderType());
        }

        workOrderMapper.updateById(workOrderEntity);

    }

    @Override
    public void executeAfter(String tableName, String buttonCode, Map data) throws ServerException, MalformedURLException {

    }
}
