package com.ebo.taskManager.dispatchRuleBtnEnhance;

import com.ebo.framework.common.exception.ServerException;
import com.ebo.module.fast.common.BtnServerEnhanceJavaInter;
import com.ebo.entity.DispatchRuleEntity;
import com.ebo.mapper.DispatchRuleMapper;
import jakarta.annotation.Resource;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.net.MalformedURLException;
import java.util.Map;

@Service
@Slf4j
public class DispatchRuleStatusChangeButtonEnhance implements BtnServerEnhanceJavaInter {
    @Resource
    private DispatchRuleMapper dispatchRuleMapper;
    @Override
    public void executeBefore(String tableName, String buttonCode, Map data) throws ServerException {

    }

    @Override
    public void executeAfter(String tableName, String buttonCode, Map data) throws ServerException, MalformedURLException {
        log.info("-----调用派单规则状态更改业务增强方法-----");
        log.info("展示data值{}",data);
        String idValue = (String) data.get("id");
        log.info("展示data值{}",idValue);
        DispatchRuleEntity dispatchRuleEntity = dispatchRuleMapper.selectById(idValue);
        String dispatchRuleStatus = dispatchRuleEntity.getStatus();
        if(dispatchRuleStatus.equals("1")){
            dispatchRuleEntity.setStatus("2");
            dispatchRuleMapper.updateById(dispatchRuleEntity);
        }else{
            dispatchRuleEntity.setStatus("1");
            dispatchRuleMapper.updateById(dispatchRuleEntity);
        }
    }
}
