package com.ebo.oms.auto;

import com.ebo.framework.core.ThreadContext;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;

import java.sql.*;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class EboDateTypeHandler extends BaseTypeHandler<Date> {

    @Override
    public void setNonNullParameter(PreparedStatement ps, int i, Date parameter, JdbcType jdbcType) throws SQLException {
        // 那么我们就可以猜测，它还支持其他的方法，Date的话，那就是setDate
        if(parameter!=null){
            try {
                ps.setTimestamp(i, new Timestamp(setDateToDbDate(parameter).getTime()));
            } catch (ParseException e) {
                throw new RuntimeException(e);
            }
        }else{
            ps.setDate(i,null);
        }

    }

    @Override
    public Date getNullableResult(ResultSet rs, String columnName) throws SQLException {
        Date date = rs.getTimestamp(columnName);
        try {
            return date == null ? null : getDbDateToBusDate(date);
        } catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Date getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        Date date = rs.getTimestamp(columnIndex);
        try {
            return date == null ? null : getDbDateToBusDate(date);
        } catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Date getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        Date date = cs.getTimestamp(columnIndex);
        try {
            return date == null ? null : getDbDateToBusDate(date);
        } catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    /**
     * 将业务时间转化成数据库存储的时间
     * @param date
     * @return
     */
    private Date setDateToDbDate(Date date) throws ParseException {
        String tenantCode = ThreadContext.getTenantCode();
        if(tenantCode.equals("111")){
            DateFormat format =  new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            System.out.println("传入时间:"+format.format(date));
            long tl = date.getTime();//模拟前端转换为中国的时间戳
            TimeZone timeZone2 = TimeZone.getTimeZone("Asia/Bangkok");
            format.setTimeZone(timeZone2);
            String d2 = format.format(tl);
            System.out.println("写入数据库时间:"+d2);//存入数据库的时间
            return format.parse(d2);
        }
        return date;
    }

    /**
     * 将数据库库存储的时间根据时区转化成业务时间
     * @param date
     * @return
     */
    private Date getDbDateToBusDate(Date date) throws ParseException {
        String tenantCode = ThreadContext.getTenantCode();
        if(tenantCode.equals("111")){
            DateFormat format =  new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            System.out.println("数据库时间:"+format.format(date));
            long tl = date.getTime();//模拟前端转换为中国的时间戳
            TimeZone timeZone2 = TimeZone.getTimeZone("Asia/Bangkok");
            format.setTimeZone(timeZone2);
            String d2 = format.format(tl);
            System.out.println("转化后业务时间:"+d2);//存入数据库的时间
            return format.parse(d2);
        }
        return date;
    }
}


