package com.ebo.workOrder.serviceBtnEnhance;

import cn.hutool.core.date.DateTime;
import com.ebo.entity.WorkOrderEntity;
import com.ebo.framework.common.exception.ServerException;
import com.ebo.mapper.WorkOrderMapper;
import com.ebo.module.fast.common.BtnServerEnhanceJavaInter;
import jakarta.annotation.Resource;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.io.Serializable;
import java.net.MalformedURLException;
import java.util.Map;
@Service
@Slf4j
public class WithdrawalBtnEnhance implements BtnServerEnhanceJavaInter {
    @Resource
    private WorkOrderMapper workOrderMapper;
    @Override
    public void executeBefore(String tableName, String buttonCode, Map data) throws ServerException {

    }

    @Override
    public void executeAfter(String tableName, String buttonCode, Map data) throws ServerException, MalformedURLException {
      log.info("-----撤回按钮业务增强-----");
      WorkOrderEntity workOrderEntity = workOrderMapper.selectById((Serializable) data.get("id"));
      if(workOrderEntity.getStatus().equals("1")){
          workOrderEntity.setWithdrawalTime(DateTime.now());
          workOrderEntity.setStatus("7");
          workOrderMapper.updateById(workOrderEntity);
      }else {
          throw new RuntimeException("状态无法更改");
      }
    }
}
