package com.ebo.workOrder.serviceBtnEnhance;

import com.ebo.framework.common.exception.ServerException;
import com.ebo.module.fast.common.BtnServerEnhanceJavaInter;
import com.ebo.entity.WorkOrderEntity;
import com.ebo.mapper.WorkOrderMapper;
import jakarta.annotation.Resource;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.net.MalformedURLException;
import java.util.Map;

@Slf4j
@Service
public class NewlyAddedBtnEnhance implements BtnServerEnhanceJavaInter {
    @Resource
    private WorkOrderMapper workOrderMapper;
    @Override
    public void executeBefore(String tableName, String buttonCode, Map data) throws ServerException {
//        log.info("值为{}",JSON.toJSON(data));
//        List temp = (List) data.get("attachment");
//        Map attachmentValue = (Map) temp.get(0);
//        String url = (String) attachmentValue.get("url");
//        data.put("attachment",url);
    }

    @Override
    public void executeAfter(String tableName, String buttonCode, Map data) throws ServerException, MalformedURLException {
        log.info("-----调用保存业务增强方法，确保工单为根工单时，根信息保存自己-----");
        String  idValue = (String) data.get("id");
        WorkOrderEntity workOrderEntity = workOrderMapper.selectById(idValue);
        // 父工单编号为空时
        if(workOrderEntity.getParentWorkOrderNumber() == null || workOrderEntity.getParentWorkOrderNumber().isEmpty()){
            // 设置根工单编号为自己
            workOrderEntity.setRootWorkOrderNumber(workOrderEntity.getWorkOrderNumber());
            // 设置根工单类型为自己
            workOrderEntity.setWorkOrderType(workOrderEntity.getWorkOrderType());
        }

        workOrderMapper.updateById(workOrderEntity);
    }
}
