package com.ebo.taskManager.tagGroupManagerBtnEnhance;

import com.ebo.framework.common.exception.ServerException;
import com.ebo.module.fast.common.BtnServerEnhanceJavaInter;
import com.ebo.entity.TagGroupEntity;
import com.ebo.mapper.TagGroupMapper;
import jakarta.annotation.Resource;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.net.MalformedURLException;
import java.util.Map;

@Service
@Slf4j
public class TagGroupManagerStatusChangeButtonEnhance implements BtnServerEnhanceJavaInter {

    @Resource
    private TagGroupMapper tagGroupMapper;
    @Override
    public void executeBefore(String tableName, String buttonCode, Map data) throws ServerException {

    }

    @Override
    public void executeAfter(String tableName, String buttonCode, Map data) throws ServerException, MalformedURLException {
        log.info("-----调用任务组状态更改业务增强方法-----");
        String  idValue = (String) data.get("id");
        TagGroupEntity tagGroupEntity = tagGroupMapper.selectById(idValue);
        if(tagGroupEntity.getStatus().equals("1")){
            tagGroupEntity.setStatus("2");
        }else {
            tagGroupEntity.setStatus("1");
        }
        tagGroupMapper.updateById(tagGroupEntity);
    }
}
