package com.ebo.module.task;

import com.ebo.module.utils.SendMessageEmail;
import com.ebo.monitor.model.Mem;
import com.xxl.job.core.handler.IJobHandler;
import com.xxl.job.core.handler.annotation.XxlJob;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;


@Component
@Slf4j
public class MemoryMonitorHandler extends IJobHandler {
    @Autowired
    private SendMessageEmail sendMessageEmail;

    @XxlJob("memoryMonitorJob")
    @Override
    public void execute() throws Exception {
        log.info("Memory Monitor Job Start");
        Mem men = new Mem();
        double usage = men.getUsage();
        double threshold = 80.0;
        if (usage > threshold) {
            try{
                log.info("开始发送邮箱");
                // 发送警报
                sendMessageEmail.sendAlert("内存占用过高警告", "目前内存占用为: " + usage + "%");
            }catch (Exception e){
                e.printStackTrace();
            }
        } else {
            log.info("内存占用正常: " + usage + "%");
        }
        log.info("Memory Monitor Job End");
    }

}