package com.ebo.workOrder.serviceBtnEnhance;

import com.alibaba.fastjson.JSON;
import com.ebo.entity.WorkOrderEntity;
import com.ebo.framework.common.exception.ServerException;
import com.ebo.mapper.WorkOrderMapper;
import com.ebo.mapper.WorkOrderServiceMapper;
import com.ebo.module.fast.common.BtnServerEnhanceJavaInter;
import jakarta.annotation.Resource;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.io.Serializable;
import java.net.MalformedURLException;
import java.util.Map;

@Service
@Slf4j
public class CloseWorkOrderServiceBtnEnhance implements BtnServerEnhanceJavaInter {
    @Autowired
    private WorkOrderMapper workOrderMapper;
    @Resource
    private WorkOrderServiceMapper workOrderServiceMapper;

    @Override
    public void executeBefore(String tableName, String buttonCode, Map data) throws ServerException {

    }

    /**
     * 业务增强往service插入数据
     * @param tableName
     * @param buttonCode
     * @param data
     * @throws ServerException
     * @throws MalformedURLException
     */
    @Override
    public void executeAfter(String tableName, String buttonCode, Map data) throws ServerException, MalformedURLException {
        log.info("-----关单业务增强-----{}", JSON.toJSON(data));
        WorkOrderEntity workOrderEntity = workOrderMapper.selectById(data.get("id").toString());
        if (workOrderEntity == null) {
            throw new ServerException("该工单已失效，请重新刷新页面");
        }
        // 获取关单类型
        String closeType = workOrderEntity.getCloseOrderType();
        //等于服务工单
//        if(workOrderEntity.getWorkOrderType().equals("1")){
//            /**
//             * 底层没改完动不了，需要进行workordernum相连，然后更改工单状态
//             * @TODO
//             */
////            if(workOrderEntity.getCloseOrderType().equals("1")){
////                workOrderServiceMapper.selectById(workOrderEntity.getWorkOrderNumber());
////
////            }
//        }else {
//            throw new RuntimeException("不是服务工单");
//        }

        if (data.get("closeOrderType").equals("1")){     // 正常关单
            if(workOrderEntity.getStatus().equals("3")){
                setMethod(workOrderEntity, data, "1");
                log.info("值为:{}",workOrderEntity.getStatus());
            }else {
                throw new ServerException("工单状态异常");
            }
        }else if (data.get("closeOrderType").equals("2")){  // 异常关单
            if(workOrderEntity.getStatus().equals("3")){
                setMethod(workOrderEntity, data, "2");
                log.info("值为:{}",workOrderEntity.getStatus());
            }else {
                throw new ServerException("工单状态异常");
            }
        }else if (data.get("closeOrderType").equals("3")){  // 转需求关单
            if(workOrderEntity.getStatus().equals("3")){
                setMethod(workOrderEntity, data,"3");
                log.info("值为:{}",workOrderEntity.getStatus());
            }else {
                throw new ServerException("工单状态异常");
            }
        }
    }

    void setMethod(WorkOrderEntity workOrderEntity, Map data,String closeType){
        workOrderEntity.setStatus("4");
        workOrderEntity.setActualWorkHours((Integer) data.get("actualWorkHours"));
        workOrderEntity.setCloseOrderDescription((String) data.get("closeOrderDescription"));
        workOrderEntity.setCloseOrderAttachment((String) data.get("closeOrderAttachment"));
        workOrderEntity.setCloseOrderType(closeType);
        workOrderMapper.updateById(workOrderEntity);
    }

}
