package com.ebo.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.util.Date;

import com.ebo.framework.mybatis.entity.BaseEntity;
import lombok.Data;

/**
 * 继承BaseEntity完成公共字段填充
 * 用于存储调度规则的表
 * @TableName dispatch_rule
 */
@TableName(value ="dispatch_rule")
@Data
public class DispatchRuleEntity extends BaseEntity implements Serializable {

    /**
     * 优先级，用于规则执行的排序
     */
    private Integer priority;

    /**
     * 状态，表示规则的当前状态（例如，启用或禁用）
     */
    private String  status;

    /**
     * 规则名称，描述规则的功能或用途
     */
    private String name;

    /**
     * 规则类别，用于分类不同的规则,1启用，2禁用
     */
    private String category;

    @TableField(exist = false)
    private static final long serialVersionUID = 1L;
}