-- MySQL dump 10.13  Distrib 8.0.34, for Win64 (x86_64)
--
-- Host: 127.0.0.1    Database: itask
-- ------------------------------------------------------
-- Server version	8.0.34

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `tag_group`
--

DROP TABLE IF EXISTS `tag_group`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `tag_group` (
  `id` bigint NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `code` varchar(255) DEFAULT NULL,
  `tenant_id` bigint DEFAULT NULL,
  `status` smallint DEFAULT NULL,
  `type` smallint DEFAULT NULL,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `create_user_id` bigint DEFAULT NULL,
  `create_user_name` varchar(255) DEFAULT NULL,
  `update_user_id` bigint DEFAULT NULL,
  `update_user_name` varchar(255) DEFAULT NULL,
  `parent_code` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `tag_option`
--

DROP TABLE IF EXISTS `tag_option`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `tag_option` (
  `id` bigint NOT NULL,
  `status` smallint DEFAULT NULL,
  `tenant_id` bigint DEFAULT NULL,
  `tag_group_id` bigint DEFAULT NULL,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `create_user_name` varchar(255) DEFAULT NULL,
  `create_user_id` bigint DEFAULT NULL,
  `update_user_name` varchar(255) DEFAULT NULL,
  `update_user_id` bigint DEFAULT NULL,
  `label` varchar(255) DEFAULT NULL,
  `value` smallint DEFAULT NULL,
  `parent_id` bigint DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `task_group`
--

DROP TABLE IF EXISTS `task_group`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `task_group` (
  `id` bigint NOT NULL,
  `status` smallint DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `task_group_admin_user_id` bigint DEFAULT NULL,
  `task_group_admin_user_name` varchar(255) DEFAULT NULL,
  `dispatch_order_type` smallint DEFAULT NULL,
  `tenant_id` bigint DEFAULT NULL,
  `work_day_count` smallint DEFAULT NULL,
  `priority` smallint DEFAULT NULL,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `create_user_name` varchar(255) DEFAULT NULL,
  `create_user_id` bigint DEFAULT NULL,
  `update_user_name` varchar(255) DEFAULT NULL,
  `update_user_id` bigint DEFAULT NULL,
  `domain` smallint DEFAULT NULL,
  `domain_name` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `task_group_rule`
--

DROP TABLE IF EXISTS `task_group_rule`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `task_group_rule` (
  `id` bigint NOT NULL,
  `created_at` datetime(6) DEFAULT NULL,
  `task_group_id` bigint DEFAULT NULL,
  `dispatch_rule_id` bigint DEFAULT NULL,
  `create_user_id` bigint DEFAULT NULL,
  `create_user_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_task_group_rule_001` (`task_group_id`,`dispatch_rule_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `task_pool`
--

DROP TABLE IF EXISTS `task_pool`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `task_pool` (
  `id` bigint NOT NULL,
  `status` smallint DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `task_pool_admin_user_id` bigint DEFAULT NULL,
  `task_pool_admin_user_name` varchar(255) DEFAULT NULL,
  `task_pool_category` smallint DEFAULT NULL,
  `tenant_id` bigint DEFAULT NULL,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `create_user_name` varchar(255) DEFAULT NULL,
  `create_user_id` bigint DEFAULT NULL,
  `update_user_name` varchar(255) DEFAULT NULL,
  `update_user_id` bigint DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `task_pool_task_group`
--

DROP TABLE IF EXISTS `task_pool_task_group`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `task_pool_task_group` (
  `id` bigint NOT NULL,
  `created_at` datetime(6) DEFAULT NULL,
  `task_pool_id` bigint DEFAULT NULL,
  `task_group_id` bigint DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_task_pool_task_group_001` (`task_pool_id`,`task_group_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `task_user`
--

DROP TABLE IF EXISTS `task_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `task_user` (
  `id` bigint NOT NULL,
  `status` smallint DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `priority` smallint DEFAULT NULL,
  `tenant_id` bigint DEFAULT NULL,
  `account_id` bigint DEFAULT NULL,
  `user_id` bigint DEFAULT NULL,
  `group_id` bigint DEFAULT NULL,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `create_user_name` varchar(255) DEFAULT NULL,
  `create_user_id` bigint DEFAULT NULL,
  `update_user_name` varchar(255) DEFAULT NULL,
  `update_user_id` bigint DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `work_order`
--

DROP TABLE IF EXISTS `work_order`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `work_order` (
  `id` bigint NOT NULL,
  `work_order_number` varchar(64) DEFAULT NULL,
  `status` smallint DEFAULT NULL,
  `auto_dispatch_status` smallint DEFAULT NULL COMMENT '自动派单状态',
  `title` varchar(1024) DEFAULT NULL,
  `description` longtext,
  `attachment` longtext,
  `priority` smallint DEFAULT NULL,
  `is_delay` smallint DEFAULT NULL,
  `external_id` bigint DEFAULT NULL COMMENT '工单属性表ID',
  `task_pool_id` bigint DEFAULT NULL,
  `task_group_id` bigint DEFAULT NULL,
  `task_group_name` varchar(255) DEFAULT NULL,
  `tenant_id` bigint DEFAULT NULL,
  `account_id` bigint DEFAULT NULL,
  `creator_department_id` bigint DEFAULT NULL,
  `creator_department_name` varchar(255) DEFAULT NULL,
  `work_order_type` smallint DEFAULT NULL,
  `parent_work_order_type` smallint DEFAULT NULL,
  `parent_work_order_number` varchar(64) DEFAULT NULL,
  `root_work_order_type` smallint DEFAULT NULL,
  `root_work_order_number` varchar(64) DEFAULT NULL,
  `is_auto_dispatch` smallint DEFAULT NULL,
  `submitter_id` bigint DEFAULT NULL,
  `submitter_name` varchar(255) DEFAULT NULL,
  `submitter_department_id` bigint DEFAULT NULL,
  `submitter_department_name` varchar(255) DEFAULT NULL,
  `dispatcher_id` bigint DEFAULT NULL,
  `dispatcher_name` varchar(255) DEFAULT NULL,
  `dispatcher_department_id` bigint DEFAULT NULL,
  `dispatcher_department_name` varchar(255) DEFAULT NULL,
  `handler_id` bigint DEFAULT NULL,
  `handler_name` varchar(255) DEFAULT NULL,
  `handler_department_id` bigint DEFAULT NULL,
  `handler_department_name` varchar(255) DEFAULT NULL,
  `follow_up_count` int DEFAULT NULL COMMENT '催办次数',
  `rejection_count` int DEFAULT NULL COMMENT '驳回次数',
  `estimated_close_time` datetime(6) DEFAULT NULL COMMENT '预计关单时间',
  `estimated_work_hours` int DEFAULT NULL COMMENT '预计需要工时，单位小时',
  `accept_time` datetime(6) DEFAULT NULL COMMENT '接单时间',
  `close_order_type` smallint DEFAULT NULL COMMENT '关单类型',
  `close_order_submission_time` datetime(6) DEFAULT NULL COMMENT '提交关单时间',
  `close_order_description` longtext COMMENT '提交关单描述',
  `close_order_attachment` longtext COMMENT '关单附件',
  `actual_close_time` datetime(6) DEFAULT NULL COMMENT '真实关单时间',
  `actual_work_hours` smallint DEFAULT NULL COMMENT '真实工时',
  `rejection_close_time` datetime(6) DEFAULT NULL COMMENT '拒绝时间',
  `rejection_reason` varchar(512) DEFAULT NULL COMMENT '拒绝原因',
  `suspension_time` datetime(6) DEFAULT NULL COMMENT '挂起时间',
  `cancel_suspension_time` datetime(6) DEFAULT NULL COMMENT '取消挂起时间',
  `suspension_count` smallint DEFAULT NULL COMMENT '挂起次数',
  `withdrawal_time` datetime(6) DEFAULT NULL COMMENT '撤回时间',
  `withdrawal_reason` varchar(512) DEFAULT NULL COMMENT '撤回原因',
  `acceptance_withdrawal_time` datetime(6) DEFAULT NULL COMMENT '验收撤回时间',
  `acceptance_withdrawal_reason` varchar(512) DEFAULT NULL COMMENT '验收撤回原因',
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `create_user_name` varchar(255) DEFAULT NULL,
  `create_user_id` bigint DEFAULT NULL,
  `update_user_name` varchar(255) DEFAULT NULL,
  `update_user_id` bigint DEFAULT NULL,
  `submitter_time` datetime(6) DEFAULT NULL COMMENT '提单时间',
  `dispatch_time` datetime(6) DEFAULT NULL COMMENT '派单时间',
  `suspension_reason` varchar(255) DEFAULT NULL COMMENT '挂起原因',
  `follow_up_time` datetime(6) DEFAULT NULL COMMENT '催办时间',
  `old_work_order` varchar(255) DEFAULT NULL COMMENT '旧的工单号',
  `oa_flow_no` varchar(255) DEFAULT NULL COMMENT '流程编号',
  `old_attachment` longtext COMMENT '旧的附件',
  `old_close_attachment` longtext COMMENT '旧的关单附件',
  `oa_flow_status` smallint DEFAULT NULL COMMENT '1审批中，2退回，3审批通过，4终止',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_work_order_001` (`work_order_number`),
  KEY `idx_work_order_002` (`parent_work_order_number`),
  KEY `idx_work_order_003` (`root_work_order_number`),
  KEY `idx_work_order_004` (`created_at`),
  KEY `idx_work_order_005` (`tenant_id`),
  KEY `idx_work_order_006` (`status`),
  KEY `idx_work_order_007` (`oa_flow_no`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `work_order_construction`
--

DROP TABLE IF EXISTS `work_order_construction`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `work_order_construction` (
  `id` bigint NOT NULL,
  `work_order_number` varchar(32) DEFAULT NULL,
  `domain` smallint DEFAULT NULL,
  `domain_name` varchar(255) DEFAULT NULL,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `create_user_id` bigint DEFAULT NULL,
  `create_user_name` varchar(255) DEFAULT NULL,
  `update_user_id` bigint DEFAULT NULL,
  `update_user_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_work_order_construction_001` (`work_order_number`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `work_order_demand`
--

DROP TABLE IF EXISTS `work_order_demand`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `work_order_demand` (
  `id` bigint NOT NULL,
  `work_order_number` varchar(64) DEFAULT NULL,
  `domain` smallint DEFAULT NULL COMMENT '所属领域',
  `domain_name` varchar(255) DEFAULT NULL COMMENT '所属领域',
  `requirement_value` varchar(512) DEFAULT NULL COMMENT '需求价值',
  `requirement_estimation` varchar(512) DEFAULT NULL COMMENT '价值估算',
  `requirement_implementation_method` smallint DEFAULT NULL COMMENT '需求实现方式',
  `requirement_implementation_method_name` varchar(255) DEFAULT NULL COMMENT '需求实现方式',
  `requirement_cost` decimal(25,2) DEFAULT NULL COMMENT '需求人天成本',
  `requirement_evaluation_man_days` decimal(25,2) DEFAULT NULL COMMENT '需求评估人天',
  `acceptance_time` datetime(6) DEFAULT NULL COMMENT '验收时间',
  `acceptance_result_time` datetime(6) DEFAULT NULL COMMENT '验收结果时间',
  `cost_evaluation_basis` varchar(512) DEFAULT NULL COMMENT '成本评估依据',
  `reviewer_user_id` bigint DEFAULT NULL COMMENT '评审人',
  `reviewer_user_name` varchar(255) DEFAULT NULL COMMENT '评审人',
  `reviewer_department_id` bigint DEFAULT NULL COMMENT '评审人部门',
  `reviewer_department_name` varchar(255) DEFAULT NULL COMMENT '评审人部门',
  `review_time` datetime(6) DEFAULT NULL COMMENT '评审时间',
  `review_attachment` longtext COMMENT '评审附件',
  `review_failure_reason` varchar(512) DEFAULT NULL COMMENT '评审失败原因',
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `create_user_id` bigint DEFAULT NULL,
  `create_user_name` varchar(255) DEFAULT NULL,
  `update_user_id` bigint DEFAULT NULL,
  `update_user_name` varchar(255) DEFAULT NULL,
  `demand_type` smallint DEFAULT NULL COMMENT '需求类型',
  `demand_type_name` varchar(255) DEFAULT NULL COMMENT '需求类型',
  `review_status` smallint DEFAULT NULL COMMENT '评审状态',
  `review_result_attachment` longtext COMMENT '评审结果附件',
  `requirement_time` datetime(6) DEFAULT NULL COMMENT '需求上线时间',
  `review_content` varchar(255) DEFAULT NULL COMMENT '评审内容',
  PRIMARY KEY (`id`),
  KEY `idx_work_order_demand_001` (`work_order_number`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `work_order_follower`
--

DROP TABLE IF EXISTS `work_order_follower`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `work_order_follower` (
  `id` bigint NOT NULL,
  `work_order_number` varchar(255) DEFAULT NULL,
  `follower_id` bigint DEFAULT NULL,
  `follower_name` varchar(255) DEFAULT NULL,
  `created_at` datetime(6) DEFAULT NULL,
  `create_user_id` bigint DEFAULT NULL,
  `create_user_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_work_order_follower_001` (`work_order_number`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `work_order_plan`
--

DROP TABLE IF EXISTS `work_order_plan`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `work_order_plan` (
  `id` bigint NOT NULL,
  `work_order_number` varchar(64) DEFAULT NULL COMMENT '工单号',
  `plan_type` smallint DEFAULT NULL COMMENT '方案类型',
  `plan_type_name` varchar(255) DEFAULT NULL COMMENT '方案类型',
  `domain` smallint DEFAULT NULL COMMENT '所属领域',
  `domain_name` varchar(255) DEFAULT NULL COMMENT '所属领域',
  `review_status` smallint DEFAULT NULL COMMENT '评审结果',
  `review_result_attachment` longtext COMMENT '评审结果附件',
  `requirement_implementation_method` smallint DEFAULT NULL COMMENT '实现方式',
  `requirement_implementation_method_name` varchar(255) DEFAULT NULL COMMENT '实现方式',
  `requirement_cost` decimal(25,2) DEFAULT NULL COMMENT '需求人天成本',
  `cost_evaluation_basis` varchar(512) DEFAULT NULL COMMENT '成本人天依据',
  `reviewer_user_id` bigint DEFAULT NULL COMMENT '评审人',
  `reviewer_user_name` varchar(255) DEFAULT NULL COMMENT '评审人',
  `reviewer_department_id` bigint DEFAULT NULL COMMENT '评审人部门',
  `reviewer_department_name` varchar(255) DEFAULT NULL COMMENT '评审人部门',
  `review_time` datetime(6) DEFAULT NULL COMMENT '评审时间',
  `review_attachment` longtext COMMENT '评审附件',
  `review_failure_reason` varchar(512) DEFAULT NULL COMMENT '评审不通过原因',
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `create_user_id` bigint DEFAULT NULL,
  `create_user_name` varchar(255) DEFAULT NULL,
  `update_user_id` bigint DEFAULT NULL,
  `update_user_name` varchar(255) DEFAULT NULL,
  `requirement_evaluation_man_days` decimal(25,2) DEFAULT NULL COMMENT '需求评估人天',
  `review_content` varchar(255) DEFAULT NULL COMMENT '评审内容',
  PRIMARY KEY (`id`),
  KEY `idx_work_order_plan_001` (`work_order_number`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `work_order_review_log`
--

DROP TABLE IF EXISTS `work_order_review_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `work_order_review_log` (
  `id` bigint NOT NULL,
  `review_status` smallint DEFAULT NULL,
  `tenant_id` bigint DEFAULT NULL,
  `work_order_number` varchar(255) DEFAULT NULL,
  `work_order_type` smallint DEFAULT NULL,
  `reviewer_user_id` bigint DEFAULT NULL,
  `reviewer_user_name` varchar(255) DEFAULT NULL,
  `reviewer_department_id` bigint DEFAULT NULL,
  `reviewer_department_name` varchar(255) DEFAULT NULL,
  `review_failure_reason` varchar(512) DEFAULT NULL,
  `review_attachment` longtext,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `create_user_id` bigint DEFAULT NULL,
  `create_user_name` varchar(255) DEFAULT NULL,
  `update_user_id` bigint DEFAULT NULL,
  `update_user_name` varchar(255) DEFAULT NULL,
  `review_result_attachment` longtext,
  `review_content` varchar(255) DEFAULT NULL COMMENT '评审内容',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `work_order_service`
--

DROP TABLE IF EXISTS `work_order_service`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `work_order_service` (
  `id` bigint NOT NULL,
  `work_order_number` varchar(64) DEFAULT NULL,
  `is_transform_demand` smallint DEFAULT NULL COMMENT '是否转需求',
  `system` smallint DEFAULT NULL COMMENT '问题系统',
  `second_level_id` smallint DEFAULT NULL COMMENT '二级问题',
  `third_level_id` smallint DEFAULT NULL COMMENT '三级问题',
  `fault_symptoms` smallint DEFAULT NULL COMMENT '故障现象',
  `problem_attribution` smallint DEFAULT NULL COMMENT '问题归因',
  `service_close_type` smallint DEFAULT NULL COMMENT '服务单关闭类型',
  `system_name` varchar(255) DEFAULT NULL COMMENT '问题系统名称',
  `second_level_name` varchar(255) DEFAULT NULL COMMENT '二级问题',
  `third_level_name` varchar(255) DEFAULT NULL COMMENT '三级问题',
  `fault_symptoms_name` varchar(255) DEFAULT NULL COMMENT '故障现象名称',
  `problem_attribution_name` varchar(255) DEFAULT NULL COMMENT '问题归因名称',
  `service_close_type_name` varchar(255) DEFAULT NULL COMMENT '服务单关闭',
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `create_user_id` bigint DEFAULT NULL,
  `create_user_name` varchar(255) DEFAULT NULL,
  `update_user_id` bigint DEFAULT NULL,
  `update_user_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_work_order_service_001` (`work_order_number`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `work_order_technology`
--

DROP TABLE IF EXISTS `work_order_technology`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `work_order_technology` (
  `id` bigint NOT NULL,
  `work_order_number` varchar(32) DEFAULT NULL,
  `system` smallint DEFAULT NULL,
  `system_name` varchar(255) DEFAULT NULL,
  `task_category` smallint DEFAULT NULL,
  `task_category_name` varchar(255) DEFAULT NULL,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `create_user_id` bigint DEFAULT NULL,
  `create_user_name` varchar(255) DEFAULT NULL,
  `update_user_id` bigint DEFAULT NULL,
  `update_user_name` varchar(255) DEFAULT NULL,
  `second_level_id` smallint DEFAULT NULL,
  `second_level_name` varchar(255) DEFAULT NULL,
  `third_level_id` smallint DEFAULT NULL,
  `third_level_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_work_order_technology_001` (`work_order_number`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2024-11-20 10:52:08
